﻿$(function () {
    'use strict';

    var $swipeTabsContainer = $('.swipe-tabs'),
		$swipeTabs = $('.swipe-tab'),
		$swipeTabsContentContainer = $('.swipe-tabs-container'),
		currentIndex = 0,
		activeTabClassName = 'active-tab';



    $swipeTabsContainer.slick({
        //slidesToShow: 3.25,
        slidesToShow: 3,
        slidesToScroll: 1,
        arrows: true,
        infinite: false,
        swipeToSlide: true,
        touchThreshold: 10

    });

    $swipeTabsContentContainer.slick({
        asNavFor: $swipeTabsContainer,
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: true,
        infinite: false,
        swipeToSlide: true,
        draggable: true,
        touchThreshold: 10
    });


    $swipeTabs.on('click', function (event) {
        // gets index of clicked tab
        currentIndex = $(this).data('slick-index');
        $swipeTabs.removeClass(activeTabClassName);
        $('.swipe-tab[data-slick-index=' + currentIndex + ']').addClass(activeTabClassName);
        $swipeTabsContainer.slick('slickGoTo', currentIndex);
        $swipeTabsContentContainer.slick('slickGoTo', currentIndex);
        //console.log("slickGoto  :" + currentIndex);
    });

    //initializes slick navigation tabs swipe handler
    $swipeTabsContentContainer.on('swipe', function (event, slick, direction) {
        currentIndex = $(this).slick('slickCurrentSlide');
        $swipeTabs.removeClass(activeTabClassName);
        $('.swipe-tab[data-slick-index=' + currentIndex + ']').addClass(activeTabClassName);
    });


    var $categoryIcon = $('.categoryIcon');
    $categoryIcon.on('click', function (event) {
        $("#detailsPage").show();
        $("#viewerPage").slideUp("slow");
        var clickObj = $(this).attr("data-type");
        $("." + clickObj).click();

        $(window).resize();

    });

    
    // Tab high-light with next previous button click
    $('.swipe-tabs-container').on('afterChange', function (event, slick, currentSlide, nextSlide) {
        console.log("(currentSlide)" + (currentSlide));
        $swipeTabs.removeClass(activeTabClassName);
        $('.swipe-tab[data-slick-index=' + (currentSlide) + ']').addClass(activeTabClassName);
    });



});